/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.TPointer64;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryWriter;
import jpcsp.remote.HTTPConfiguration;
import jpcsp.remote.HTTPServer;
import jpcsp.util.ThreadLocalCookieManager;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceHttp
extends HLEModule {
    public static Logger log = Modules.getLogger("sceHttp");
    public static final int PSP_HTTP_SYSTEM_COOKIE_HEAP_SIZE = 133120;
    private boolean isHttpInit;
    private boolean isSystemCookieLoaded;
    private int maxMemSize;
    private SysMemUserForUser.SysMemInfo memInfo;
    protected HashMap<Integer, HttpTemplate> httpTemplates = new HashMap();
    protected HashMap<Integer, HttpConnection> httpConnections = new HashMap();
    protected HashMap<Integer, HttpRequest> httpRequests = new HashMap();
    private CookieManager cookieManager;
    private static final String[] httpMethods = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE", "CONNECT"};

    @Override
    public void start() {
        CookieHandler.setDefault(new ThreadLocalCookieManager());
        this.cookieManager = new CookieManager();
        super.start();
    }

    public void checkHttpInit() {
        if (!this.isHttpInit) {
            throw new SceKernelErrorException(-2143088639);
        }
    }

    private static Proxy getProxyForUrl(String url) {
        for (HTTPConfiguration.HttpServerConfiguration httpServerConfiguration : HTTPConfiguration.doProxyServers) {
            if (!httpServerConfiguration.isMatchingUrl(url)) continue;
            return HTTPServer.getInstance().getProxy();
        }
        return null;
    }

    public static String patchUrl(String url) {
        for (HTTPConfiguration.HttpServerConfiguration httpServerConfiguration : HTTPConfiguration.doProxyServers) {
            if (!httpServerConfiguration.isHttps() || !httpServerConfiguration.isMatchingUrl(url)) continue;
            return url.replaceFirst("https", "http");
        }
        return url;
    }

    protected HttpRequest getHttpRequest(int requestId) {
        HttpRequest httpRequest = this.httpRequests.get(requestId);
        if (httpRequest == null) {
            throw new SceKernelErrorException(-2147483137);
        }
        return httpRequest;
    }

    protected HttpConnection getHttpConnection(int connectionId) {
        HttpConnection httpConnection = this.httpConnections.get(connectionId);
        if (httpConnection == null) {
            throw new SceKernelErrorException(-2147483137);
        }
        return httpConnection;
    }

    protected boolean isHttpTemplateId(int templateId) {
        return this.httpTemplates.containsKey(templateId);
    }

    protected HttpTemplate getHttpTemplate(int templateId) {
        HttpTemplate httpTemplate = this.httpTemplates.get(templateId);
        if (httpTemplate == null) {
            throw new SceKernelErrorException(-2147483137);
        }
        return httpTemplate;
    }

    private int getTempMemory() {
        if (this.memInfo == null) {
            this.memInfo = Modules.SysMemUserForUserModule.malloc(5, "sceHttp", 0, this.maxMemSize, 0);
            if (this.memInfo == null) {
                return 0;
            }
        }
        return this.memInfo.addr;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=-1424310777, version=150, checkInsideInterrupt=true)
    public int sceHttpInit(int heapSize) {
        if (this.isHttpInit) {
            return -2143088608;
        }
        this.maxMemSize = heapSize;
        this.isHttpInit = true;
        this.memInfo = null;
        int addr = this.getTempMemory();
        if (addr == 0) {
            log.warn((Object)String.format("sceHttpInit cannot allocate 0x%X bytes", this.maxMemSize));
            return -1;
        }
        Utilities.disableSslCertificateChecks();
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-775383970, version=150, checkInsideInterrupt=true)
    public int sceHttpEnd() {
        this.checkHttpInit();
        this.isSystemCookieLoaded = false;
        this.isHttpInit = false;
        if (this.memInfo != null) {
            Modules.SysMemUserForUserModule.free(this.memInfo);
            this.memInfo = null;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=42116029, version=150)
    public int sceHttpGetContentLength(int requestId, @BufferInfo(usage=BufferInfo.Usage.out) TPointer64 contentLengthAddr) {
        int result;
        HttpRequest httpRequest = this.getHttpRequest(requestId);
        httpRequest.connect();
        long contentLength = httpRequest.getContentLength();
        if (contentLength < 0L) {
            result = -2143088527;
        } else {
            contentLengthAddr.setValue(contentLength);
            result = 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceHttpGetContentLength request %s returning 0x%X, contentLength=0x%X", httpRequest, result, contentLengthAddr.getValue()));
        }
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=64574063, version=150)
    public int sceHttpSetResolveRetry(int templateId, int count) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=105417244, version=150)
    public int sceHttpSetCookieSendCallback() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=134858801, version=150)
    public int sceHttpEnableRedirect(int id) {
        if (this.isHttpTemplateId(id)) {
            HttpTemplate httpTemplate = this.getHttpTemplate(id);
            httpTemplate.setEnableRedirect(true);
        } else {
            HttpConnection httpConnection = this.getHttpConnection(id);
            httpConnection.setEnableRedirect(true);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=185773051, version=150)
    public int sceHttpDisableCookie(int templateId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=229614991, version=150)
    public int sceHttpEnableCookie(int templateId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=357826948, version=150)
    public int sceHttpDeleteHeader(int templateId, int name) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=437173097, version=150)
    public int sceHttpDisableRedirect(int id) {
        if (this.isHttpTemplateId(id)) {
            HttpTemplate httpTemplate = this.getHttpTemplate(id);
            httpTemplate.setEnableRedirect(false);
        } else {
            HttpConnection httpConnection = this.getHttpConnection(id);
            httpConnection.setEnableRedirect(false);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=485341652, version=150)
    public int sceHttpFlushCache() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=521126883, version=150)
    public int sceHttpSetRecvTimeOut(int templateId, int timeout) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=576017694, version=150)
    public int sceHttpGetNetworkPspError(int connectionId, TPointer32 errorAddr) {
        errorAddr.setValue(0);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=645273844, version=150)
    public int sceHttpSetAuthInfoCallback(int templateId, TPointer callback, int callbackArg) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=711733910, version=150)
    public int sceHttpSetAuthInfoCB() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=742163151, version=150)
    public int sceHttpFlushAuthList() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=979890950, version=150)
    public int sceHttpSetCookieRecvCallback() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1051435653, version=150)
    public int sceHttpAddExtraHeader(int requestId, PspString name, PspString value, int unknown1) {
        HttpRequest httpRequest = this.getHttpRequest(requestId);
        httpRequest.addHeader(name.getString(), value.getString());
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1194621776, version=150)
    public int sceHttpCreateRequest(int connectionId, int method, PspString path, long contentLength) {
        HttpConnection httpConnection = this.getHttpConnection(connectionId);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setMethod(method);
        httpRequest.setPath(path.getString());
        httpRequest.setContentLength(contentLength);
        httpConnection.addHttpRequest(httpRequest);
        return httpRequest.getId();
    }

    @HLEUnimplemented
    @HLEFunction(nid=1200882742, version=150)
    public int sceHttpSetResolveTimeOut(int templateId, int timeout) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1288165263, version=150)
    public int sceHttpGetStatusCode(int requestId, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 statusCode) {
        HttpRequest httpRequest = this.getHttpRequest(requestId);
        httpRequest.connect();
        statusCode.setValue(httpRequest.getStatusCode());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceHttpGetStatusCode on request %s returning statusCode=%d", httpRequest, statusCode.getValue()));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1364358971, version=150)
    public int sceHttpDeleteConnection(int connectionId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1424482165, version=150)
    public int sceHttpIsRequestInCache(int requestId, int unknown1, int unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1508299119, version=150)
    public int sceHttpEnableCache(int templateId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1993422395, version=150, checkInsideInterrupt=true)
    public int sceHttpSaveSystemCookie() {
        this.checkHttpInit();
        if (!this.isSystemCookieLoaded) {
            return -2143088520;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2004139852, version=150)
    public int sceHttpAddCookie(PspString url, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer cookieAddr, int length) {
        String cookie = cookieAddr.getStringNZ(length);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceHttpAddCookie for URL '%s': '%s'", url.getString(), cookie));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2012107545, version=150)
    public int sceHttpLoadAuthList() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2023805932, version=150)
    public int sceHttpEnableKeepAlive(int templateId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2025147401, version=150)
    public int sceHttpEndCache() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1966268557, version=150)
    public int sceHttpSetConnectTimeOut(int templateId, int timeout) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1896883885, version=150)
    public int sceHttpCreateConnection(int templateId, PspString host, PspString protocol, int port, int unknown1) {
        HttpTemplate httpTemplate = this.getHttpTemplate(templateId);
        HttpConnection httpConnection = new HttpConnection();
        httpConnection.setUrl(host.getString(), protocol.getString(), port);
        httpTemplate.addHttpConnection(httpConnection);
        return httpConnection.getId();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1793249010, version=150)
    public int sceHttpDisableProxyAuth() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1771534772, version=150)
    public int sceHttpSetRecvBlockSize() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1762562754, version=150)
    public int sceHttpGetCookie(PspString url, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextNextParameter, usage=BufferInfo.Usage.out) TPointer cookie, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 cookieLengthAddr, int prepare, int secure) {
        return -2143088603;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1719134419, version=150)
    public int sceHttpSetSendTimeOut(int templateId, int timeout) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1694721870, version=150)
    public int sceHttpSendRequestInCacheFirstMode() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1692459210, version=150)
    public int sceHttpCreateTemplate(PspString agent, int unknown1, int unknown2) {
        HttpTemplate httpTemplate = new HttpTemplate();
        httpTemplate.setAgent(agent.getString());
        return httpTemplate.getId();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1614417651, version=150)
    public int sceHttpEnableAuth(int templateId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1538691611, version=150)
    public int sceHttpSetRedirectCallback(int templateId, @CanBeNull TPointer callbackAddr, int callbackArg) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1521406463, version=150)
    public int sceHttpDeleteRequest(int requestId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1501557708, version=150)
    public int sceHttpInitCache() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1365995538, version=150)
    public int sceHttpDisableAuth(int templateId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1329378531, version=150)
    public int sceHttpSetCacheContentLengthMaxSize() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1257656162, version=150)
    public int sceHttpCreateRequestWithURL(int connectionId, int method, PspString url, long contentLength) {
        HttpConnection httpConnection = this.getHttpConnection(connectionId);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setMethod(method);
        httpRequest.setUrl(url.getString());
        httpRequest.setContentLength(contentLength);
        httpConnection.addHttpRequest(httpRequest);
        return httpRequest.getId();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1150259089, version=150)
    public int sceHttpSendRequest(int requestId, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer data, int dataSize) {
        HttpRequest httpRequest = this.getHttpRequest(requestId);
        httpRequest.send(data.getAddress(), dataSize);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1056216103, version=150)
    public int sceHttpAbortRequest(int requestId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-969733363, version=150)
    public int sceHttpChangeHttpVersion() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-940628647, version=150)
    public int sceHttpDisableKeepAlive(int templateId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-913523801, version=150)
    public int sceHttpSetResHeaderMaxSize() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-860023174, version=150)
    public int sceHttpDisableCache(int templateId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-844047272, version=150)
    public int sceHttpEnableProxyAuth() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-839324487, version=150)
    public int sceHttpCreateConnectionWithURL(int templateId, PspString url, int unknown1) {
        HttpTemplate httpTemplate = this.getHttpTemplate(templateId);
        HttpConnection httpConnection = new HttpConnection();
        httpConnection.setUrl(url.getString());
        httpTemplate.addHttpConnection(httpConnection);
        return httpConnection.getId();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-796791665, version=150)
    public int sceHttpGetNetworkErrno(int requestId, TPointer32 errno) {
        errno.setValue(0);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-686995385, version=150)
    public int sceHttpGetProxy() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-618238769, version=150)
    public int sceHttpGetAllHeader(int requestId, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 headerAddr, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 headerLengthAddr) {
        HttpRequest httpRequest = this.getHttpRequest(requestId);
        httpRequest.connect();
        String allHeaders = httpRequest.getAllHeaders();
        if (allHeaders == null) {
            return -1;
        }
        int addr = this.getTempMemory();
        Utilities.writeStringZ(Memory.getInstance(), addr, allHeaders);
        headerAddr.setValue(addr);
        headerLengthAddr.setValue(allHeaders.length());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceHttpGetAllHeader returning at 0x%08X: %s", addr, Utilities.getMemoryDump(addr, headerLengthAddr.getValue())));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-579962793, version=150)
    public int sceHttpSaveAuthList() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-303122023, version=150)
    public int sceHttpReadData(int requestId, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.returnValue, usage=BufferInfo.Usage.out) TPointer data, int dataSize) {
        HttpRequest httpRequest = this.getHttpRequest(requestId);
        httpRequest.connect();
        int readSize = httpRequest.readData(data.getAddress(), dataSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceHttpReadData returning 0x%X: %s", readSize, Utilities.getMemoryDump(data.getAddress(), readSize)));
        }
        return readSize;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-252416926, version=150)
    public int sceHttpSetProxy() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-245007582, version=150, checkInsideInterrupt=true)
    public int sceHttpLoadSystemCookie() {
        this.checkHttpInit();
        if (this.isSystemCookieLoaded) {
            return -2143088608;
        }
        if (this.maxMemSize < 133120) {
            return -2143088521;
        }
        this.isSystemCookieLoaded = true;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-191286026, version=150)
    public int sceHttpSetMallocFunction(TPointer function1, TPointer function2, TPointer function3) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-50806699, version=150)
    public int sceHttpDeleteTemplate(int templateId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2014189978, version=150)
    public int sceHttp_87F1E666(int templateId, int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1011318852, version=150)
    public int sceHttp_3C478044(int templateId, int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1939615097, version=150)
    public int sceHttpInitExternalCache() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1537105561, version=150)
    public int sceHttpEndExternalCache() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2142838192, version=150)
    public int sceHttpEnableExternalCache() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1339721949, version=150)
    public int sceHttpFlushExternalCache() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1165828637, version=150)
    public int sceHttpFlushCookie() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1313482826, version=150)
    public int sceHttpCloneTemplate(int templateId) {
        HttpTemplate clonedHttpTemplate = new HttpTemplate();
        HttpTemplate httpTemplate = this.getHttpTemplate(templateId);
        clonedHttpTemplate.setAgent(httpTemplate.getAgent());
        return clonedHttpTemplate.getId();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-670308511, version=150)
    public int sceHttp_D80BE761(int templateId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1458965842, version=150)
    public int sceHttp_A909F2AE1() {
        return 0;
    }

    protected static class HttpTemplate {
        private static final String uidPurpose = "sceHttp-HttpTemplate";
        private int id;
        private HashMap<Integer, HttpConnection> httpConnections = new HashMap();
        private String agent;
        private boolean enableRedirect;

        public HttpTemplate() {
            this.id = SceUidManager.getNewUid(uidPurpose);
            Modules.sceHttpModule.httpTemplates.put(this.id, this);
        }

        public void delete() {
            for (HttpConnection httpConnection : this.httpConnections.values()) {
                httpConnection.delete();
            }
            this.httpConnections.clear();
            Modules.sceHttpModule.httpTemplates.remove(this.id);
            SceUidManager.releaseUid(this.id, uidPurpose);
            this.id = -1;
        }

        public void addHttpConnection(HttpConnection httpConnection) {
            httpConnection.setHttpTemplate(this);
            httpConnection.setEnableRedirect(this.isEnableRedirect());
            this.httpConnections.put(httpConnection.getId(), httpConnection);
        }

        public int getId() {
            return this.id;
        }

        public String getAgent() {
            return this.agent;
        }

        public void setAgent(String agent) {
            this.agent = agent;
        }

        public boolean isEnableRedirect() {
            return this.enableRedirect;
        }

        public void setEnableRedirect(boolean enableRedirect) {
            this.enableRedirect = enableRedirect;
        }

        public String toString() {
            return String.format("HttpTemplate id=%d, agent='%s'", this.getId(), this.getAgent());
        }
    }

    protected static class HttpConnection {
        private static final String uidPurpose = "sceHttp-HttpConnection";
        private int id;
        private HashMap<Integer, HttpRequest> httpRequests = new HashMap();
        private String url;
        private HttpTemplate httpTemplate;
        private boolean enableRedirect;

        public HttpConnection() {
            this.id = SceUidManager.getNewUid(uidPurpose);
            Modules.sceHttpModule.httpConnections.put(this.id, this);
        }

        public void delete() {
            for (HttpRequest httpRequest : this.httpRequests.values()) {
                httpRequest.delete();
            }
            this.httpRequests.clear();
            Modules.sceHttpModule.httpConnections.remove(this.id);
            SceUidManager.releaseUid(this.id, uidPurpose);
            this.id = -1;
        }

        public void addHttpRequest(HttpRequest httpRequest) {
            httpRequest.setHttpConnection(this);
            this.httpRequests.put(httpRequest.getId(), httpRequest);
        }

        public int getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public int getDefaultPort(String protocol) {
            if ("http".equals(protocol)) {
                return 80;
            }
            if ("https".equals(protocol)) {
                return 443;
            }
            return -1;
        }

        public void setUrl(String host, String protocol, int port) {
            this.url = String.format("%s://%s", protocol, host);
            if (port != this.getDefaultPort(protocol)) {
                this.url = this.url + String.format(":%s", port);
            }
        }

        public HttpTemplate getHttpTemplate() {
            return this.httpTemplate;
        }

        public void setHttpTemplate(HttpTemplate httpTemplate) {
            this.httpTemplate = httpTemplate;
        }

        public boolean isEnableRedirect() {
            return this.enableRedirect;
        }

        public void setEnableRedirect(boolean enableRedirect) {
            this.enableRedirect = enableRedirect;
        }

        public String toString() {
            return String.format("HttpConnection id=%d, url='%s'", this.getId(), this.getUrl());
        }
    }

    protected static class HttpRequest {
        private static final String uidPurpose = "sceHttp-HttpRequest";
        private int id;
        private String url;
        private String path;
        private int method;
        private long contentLength;
        private HttpConnection httpConnection;
        private URLConnection urlConnection;
        private HttpURLConnection httpUrlConnection;
        private HashMap<String, String> headers = new HashMap();
        private byte[] sendData;
        private int sendDataLength;

        public HttpRequest() {
            this.id = SceUidManager.getNewUid(uidPurpose);
            Modules.sceHttpModule.httpRequests.put(this.id, this);
        }

        public void delete() {
            Modules.sceHttpModule.httpRequests.remove(this.id);
            SceUidManager.releaseUid(this.id, uidPurpose);
            this.id = -1;
        }

        public int getId() {
            return this.id;
        }

        public String getUrl() {
            if (this.url != null) {
                return this.url;
            }
            if (this.path != null) {
                if (this.path.startsWith("http:") || this.path.startsWith("https:")) {
                    return this.path;
                }
                return this.getHttpConnection().getUrl() + this.path;
            }
            return null;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public int getMethod() {
            return this.method;
        }

        public void setMethod(int method) {
            this.method = method;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public void setContentLength(long contentLength) {
            this.contentLength = contentLength;
        }

        public HttpConnection getHttpConnection() {
            return this.httpConnection;
        }

        public void setHttpConnection(HttpConnection httpConnection) {
            this.httpConnection = httpConnection;
        }

        public void send(int data, int dataSize) {
            if (dataSize > 0) {
                this.sendData = Utilities.extendArray(this.sendData, dataSize);
                Utilities.readBytes(data, dataSize, this.sendData, this.sendDataLength);
                this.sendDataLength += dataSize;
            }
        }

        public void connect() {
            String sendUrl;
            Proxy proxy;
            if (this.urlConnection != null) {
                return;
            }
            ThreadLocalCookieManager.setCookieManager(Modules.sceHttpModule.cookieManager);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("HttpRequest %s send: %s", this, Utilities.getMemoryDump(this.sendData, 0, this.sendDataLength)));
            }
            if ((proxy = sceHttp.getProxyForUrl(sendUrl = this.getUrl())) != null && sendUrl.startsWith("https:")) {
                sendUrl = "http:" + sendUrl.substring(6);
            }
            try {
                this.urlConnection = proxy != null ? new URL(sendUrl).openConnection(proxy) : new URL(sendUrl).openConnection();
                String agent = this.getHttpConnection().getHttpTemplate().getAgent();
                if (agent != null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("Adding header '%s': '%s'", "User-Agent", agent));
                    }
                    this.urlConnection.setRequestProperty("User-Agent", agent);
                }
                for (String header : this.headers.keySet()) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("Adding header '%s': '%s'", header, this.headers.get(header)));
                    }
                    this.urlConnection.setRequestProperty(header, this.headers.get(header));
                }
                if (this.urlConnection instanceof HttpURLConnection) {
                    this.httpUrlConnection = (HttpURLConnection)this.urlConnection;
                    this.httpUrlConnection.setRequestMethod(httpMethods[this.method]);
                    this.httpUrlConnection.setInstanceFollowRedirects(this.getHttpConnection().isEnableRedirect());
                    if (this.sendDataLength > 0) {
                        this.httpUrlConnection.setDoOutput(true);
                        OutputStream os = this.httpUrlConnection.getOutputStream();
                        os.write(this.sendData, 0, this.sendDataLength);
                        os.close();
                    }
                } else {
                    this.httpUrlConnection = null;
                }
                this.urlConnection.connect();
                this.setContentLength(this.urlConnection.getContentLength());
            }
            catch (MalformedURLException e) {
                log.error((Object)"HttpRequest.send", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"HttpRequest.send", (Throwable)e);
            }
        }

        public int readData(int data, int dataSize) {
            int bufferLength;
            byte[] buffer = new byte[dataSize];
            try {
                int readSize;
                for (bufferLength = 0; bufferLength < dataSize && (readSize = this.urlConnection.getInputStream().read(buffer, bufferLength, dataSize - bufferLength)) >= 0; bufferLength += readSize) {
                }
            }
            catch (FileNotFoundException e) {
                log.debug((Object)"HttpRequest.readData", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"HttpRequest.readData", (Throwable)e);
            }
            if (bufferLength > 0) {
                IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(data, bufferLength, 1);
                for (int i = 0; i < bufferLength; ++i) {
                    memoryWriter.writeNext(buffer[i] & 0xFF);
                }
                memoryWriter.flush();
            }
            return bufferLength;
        }

        public String getAllHeaders() {
            if (this.urlConnection == null) {
                return null;
            }
            StringBuilder allHeaders = new StringBuilder();
            Map<String, List<String>> properties = this.urlConnection.getHeaderFields();
            for (String key : properties.keySet()) {
                if (key == null) continue;
                List<String> values = properties.get(key);
                for (String value : values) {
                    allHeaders.append(String.format("%s: %s\r\n", key, value));
                }
            }
            return allHeaders.toString();
        }

        public int getStatusCode() {
            int statusCode = 0;
            if (this.httpUrlConnection != null) {
                try {
                    statusCode = this.httpUrlConnection.getResponseCode();
                }
                catch (IOException e) {
                    log.error((Object)"HttpRequest.getStatusCode", (Throwable)e);
                }
            }
            return statusCode;
        }

        private void addHeader(String name, String value) {
            this.headers.put(name, value);
        }

        public String toString() {
            return String.format("HttpRequest id=%d, url='%s', method=%d, contentLength=%d", this.getId(), this.getUrl(), this.getMethod(), this.contentLength);
        }
    }
}

